#include <iostream>
#include <cstdio>
#include <cstdlib>
#include <cmath>
#include <ctime>
#include <cstring>
#include <cassert>
#include <algorithm>
#include <vector>
#include <set>
#include <map>
#include <bitset>
#include <stack>
#include <queue>
#include <deque>
#include <complex>

using namespace std;

#define pb push_back
#define mp make_pair
#define sz(s) int((s).size())
#define len(s) int((s).size())
#define all(s) (s).begin(), (s).end()
#ifdef _WIN32
#define LLD "%I64d"
#else
#define LLD "%lld"
#endif
#ifdef LOCAL42
#define eprintf(...) fprintf(stderr, __VA_ARGS__)
#else
#define eprintf(...) 42
#endif
#define y0 yy0
#define y1 yy1
#define next _next
#define prev _prev
#define rank _rank
#define link _link
#define hash _hash
#define fs first
#define sc second

typedef long long ll;
typedef long long llong;
typedef long long int64;
typedef unsigned int uint;
typedef long double ld;
typedef unsigned long long ull;
typedef unsigned long long ullong;
typedef unsigned long long lint;
typedef pair<int, int> pii;
typedef vector<int> vi;

const int inf = int(1e9);
const double eps = 1e-9;
const double pi = 4 * atan(double(1));

namespace dinic {
	const int N = 1e5 + 100;

	int n, m = 0, s, t;
	vector<int> g[N], rg[N];
	int color[N];
	
	void init(int _n, int _s, int _t) {
		n = _n, m = 0;
		for (int i = 0; i < n; i++) {
			color[i] = 0;
		}
		for (int i = 0; i < n; i++) {
			g[i].clear();
			rg[i].clear();
		}
		s = _s, t = _t;
	}

	int a[N], b[N], f[N], cf[N];

	void addEdge(int u, int v, int _f) {
		a[m] = u, b[m] = v, f[m] = 0, cf[m] = _f, g[u].pb(m), rg[v].pb(m), m++;
		a[m] = v, b[m] = u, f[m] = 0, cf[m] = 0, g[v].pb(m), rg[u].pb(m), m++;
	}

	int stateUsed[N], stateFirst[N];
	bool used[N];
	int first[N];
	int curStateUsed = 1, curStateFirst = 1;
	
	bool &getUsed(int index) {
		if (stateUsed[index] != curStateUsed)
			used[index] = 0, stateUsed[index] = curStateUsed;
		return used[index];
	}

	int &getFirst(int index) {
		if (stateFirst[index] != curStateFirst)
			first[index] = 0, stateFirst[index] = curStateFirst;
		return first[index];
	}

	deque<int> q;
	int dist[N];

	void bfs() {
		fill_n(dist, n, inf);
		dist[s] = 0, q.pb(s);
		while (!q.empty()) {
			int v = q.front(); q.pop_front();
			for (int i = 0; i < len(g[v]); i++) {
				int e = g[v][i], to = b[e];
				if (cf[e] <= 0)
					continue;
				if (dist[to] > dist[v] + 1) {
					dist[to] = dist[v] + 1;
					q.pb(to);
				}
			}
		}
	}

	int dfs(int v, int flow = inf) {
		if (v == t)
			return flow;
		bool &used = getUsed(v);
		if (used)
			return 0;
		used = true;
		for (int &i = getFirst(v); i < len(g[v]); i++) {
			int e = g[v][i], to = b[e];
			if (cf[e] <= 0 || dist[v] + 1 != dist[to])
				continue;
			int res = dfs(to, min(flow, cf[e]));
			if (res == 0)
				continue;
			cf[e] -= res, f[e] += res;
			cf[e ^ 1] += res, f[e ^ 1] -= res;
			return res;
		}
		return 0;
	}

	int dinic() {
		int ans = 0;
		for (;;) {
			curStateFirst++;
			bfs();
			if (dist[t] == inf)
				break;
			for (;;) {
				curStateUsed++;
				int add = dfs(s);
				if (add == 0)
					break;
				ans += add;
			}
		}
		return ans;
	}

	void colorize(int v, int cc, bool flag) {
		if (color[v] != 0)
			return ;
		color[v] = cc;
		vector<int> *gg = flag ? rg : g;
		for (int i = 0; i < len(gg[v]); i++) {
			int e = gg[v][i], to = v ^ a[e] ^ b[e];
			if (cf[e] > 0) {
				colorize(to, cc, flag);
			}
		}
	}
};

int main() {
#ifdef LOCAL42
#define TASK "F"
	freopen(TASK ".in", "r", stdin);
	freopen(TASK ".out", "w", stdout);
#else

#endif
	int n, m, s, t;
	while (scanf("%d%d%d%d", &n, &m, &s, &t) && n != 0) {
		s--, t--;
		vector<pair<int, int> > e(m);
		for (int i = 0; i < m; i++) {
			assert(scanf("%d%d", &e[i].fs, &e[i].sc) == 2);
			e[i].fs--, e[i].sc--;
		}
		dinic::init(n, s, t);
		for (int i = 0; i < m; i++) {
			dinic::addEdge(e[i].fs, e[i].sc, 1);
		}
		int flow = dinic::dinic();
		dinic::colorize(s, 1, false);
		dinic::colorize(t, 2, true);
		int ans = 0;
		for (int i = 0; i < m; i++) {
			if (dinic::color[e[i].fs] == 2 && dinic::color[e[i].sc] == 1)
				ans++;
		}
		printf("%d %d\n", flow + (ans != 0), ans);
		eprintf("%d %d\n", flow + (ans != 0), ans);
	}
	return 0;
}
